<?php
/**
 * Prohibit direct script loading.
 *
 * @package Convert_Plus.
 */

// Add new input type "switch".
if ( function_exists( 'smile_add_input_type' ) ) {
	smile_add_input_type( 'switch', 'switch_settings_field' );
}

add_action( 'admin_enqueue_scripts', 'smile_switch_image_scripts' );
/**
 * Function Name:smile_switch_image_scripts description.
 *
 * @param  array $hook ap page list.
 */
function smile_switch_image_scripts( $hook ) {
	$cp_page = strpos( $hook, 'plus_page' );
	$data    = get_option( 'convert_plug_debug' );

	if ( isset( $data['cp-dev-mode'] ) && '1' === $data['cp-dev-mode'] ) {
		wp_enqueue_style( 'convert-plus-switch', SMILE_FRAMEWORK_URI . '/lib/fields/switch/switch.css', array(), CP_VERSION );
		wp_enqueue_script( 'convert-plus-switch', SMILE_FRAMEWORK_URI . '/lib/fields/switch/switch.js', array(), '1.0.0', true );
	}
}

/**
 * Function Name:txt_link_settings_field Function to handle new input type "switch".
 *
 * @param  string $name     settings provided when using the input type "switch".
 * @param  string $settings holds the default / updated value.
 * @param  string $value    html output generated by the function.
 * @return string           html output generated by the function.
 */
function switch_settings_field( $name, $settings, $value ) {
	$input_name = $name;
	$type       = isset( $settings['type'] ) ? $settings['type'] : '';
	$class      = isset( $settings['class'] ) ? $settings['class'] : '';
	$on         = isset( $settings['on'] ) ? $settings['on'] : 'ON';
	$off        = isset( $settings['off'] ) ? $settings['off'] : 'OFF';
	$checked    = ( $value ) ? 'checked="checked"' : '';
	$uniq       = uniqid();
	$output     = '<div class="switch-wrapper">';

	$output .= '<input type="text" ' . $checked . ' id="smile_' . $input_name . '" class="form-control smile-input smile-switch-input ' . $class . '" name="' . $input_name . '" value="' . $value . '" />';
	$output .= '<input type="checkbox" ' . $checked . ' id="smile_' . $input_name . '_btn_' . $uniq . '" class="ios-toggle smile-input smile-switch-input switch-checkbox smile-' . $type . ' ' . $class . '" value="' . $value . '"   >';
	$output .= '<label class="smile-switch-btn checkbox-label" data-on="' . $on . '"  data-off="' . $off . '" data-id="smile_' . $input_name . '" for="smile_' . $input_name . '_btn_' . $uniq . '">
	</label>';
	$output .= '</div>';
	return $output;
}
